/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.config;

import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.config.BackendType;
import com.jozufozu.flywheel.config.BackendTypeArgument;
import com.jozufozu.flywheel.config.FlwConfig;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.function.BiConsumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraftforge.client.event.RegisterClientCommandsEvent;
import net.minecraftforge.common.ForgeConfigSpec;
import org.jetbrains.annotations.NotNull;

public class FlwCommands {
    public static void registerClientCommands(RegisterClientCommandsEvent event) {
        FlwConfig config = FlwConfig.get();
        ConfigCommandBuilder commandBuilder = new ConfigCommandBuilder("flywheel");
        commandBuilder.addValue(config.client.backend, "backend", (builder, value) -> ((LiteralArgumentBuilder)builder.executes(context -> {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player != null) {
                player.m_5661_(FlwCommands.getEngineMessage((BackendType)((Object)((Object)((Object)value.get())))), false);
            }
            return 1;
        })).then(Commands.m_82129_((String)"type", (ArgumentType)BackendTypeArgument.INSTANCE).executes(context -> {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player != null) {
                BackendType type = (BackendType)((Object)((Object)((Object)context.getArgument("type", BackendType.class))));
                value.set((Object)type);
                Component message = FlwCommands.getEngineMessage(type);
                player.m_5661_(message, false);
                Backend.reloadWorldRenderers();
            }
            return 1;
        })));
        commandBuilder.addValue(config.client.debugNormals, "debugNormals", (builder, value) -> FlwCommands.booleanValueCommand((LiteralArgumentBuilder<CommandSourceStack>)builder, (ForgeConfigSpec.ConfigValue<Boolean>)value, (source, bool) -> {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player == null) {
                return;
            }
            MutableComponent text = new TextComponent("Normal debug mode is currently: ").m_7220_((Component)FlwCommands.boolToText(bool));
            player.m_5661_((Component)text, false);
        }, (source, bool) -> {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player == null) {
                return;
            }
            MutableComponent text = FlwCommands.boolToText(bool).m_7220_((Component)new TextComponent(" normal debug mode").m_130940_(ChatFormatting.WHITE));
            player.m_5661_((Component)text, false);
        }));
        commandBuilder.addValue(config.client.limitUpdates, "limitUpdates", (builder, value) -> FlwCommands.booleanValueCommand((LiteralArgumentBuilder<CommandSourceStack>)builder, (ForgeConfigSpec.ConfigValue<Boolean>)value, (source, bool) -> {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player == null) {
                return;
            }
            MutableComponent text = new TextComponent("Update limiting is currently: ").m_7220_((Component)FlwCommands.boolToText(bool));
            player.m_5661_((Component)text, false);
        }, (source, bool) -> {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player == null) {
                return;
            }
            MutableComponent text = FlwCommands.boolToText(bool).m_7220_((Component)new TextComponent(" update limiting.").m_130940_(ChatFormatting.WHITE));
            player.m_5661_((Component)text, false);
            Backend.reloadWorldRenderers();
        }));
        commandBuilder.build((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    public static void booleanValueCommand(LiteralArgumentBuilder<CommandSourceStack> builder, ForgeConfigSpec.ConfigValue<Boolean> value, BiConsumer<CommandSourceStack, Boolean> displayAction, BiConsumer<CommandSourceStack, Boolean> setAction) {
        ((LiteralArgumentBuilder)((LiteralArgumentBuilder)builder.executes(context -> {
            displayAction.accept((CommandSourceStack)context.getSource(), (Boolean)value.get());
            return 1;
        })).then(Commands.m_82127_((String)"on").executes(context -> {
            value.set((Object)true);
            setAction.accept((CommandSourceStack)context.getSource(), (Boolean)value.get());
            return 1;
        }))).then(Commands.m_82127_((String)"off").executes(context -> {
            value.set((Object)false);
            setAction.accept((CommandSourceStack)context.getSource(), (Boolean)value.get());
            return 1;
        }));
    }

    public static MutableComponent boolToText(boolean b) {
        return b ? new TextComponent("enabled").m_130940_(ChatFormatting.DARK_GREEN) : new TextComponent("disabled").m_130940_(ChatFormatting.RED);
    }

    public static Component getEngineMessage(@NotNull BackendType type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case BackendType.OFF -> new TextComponent("Disabled Flywheel").m_130940_(ChatFormatting.RED);
            case BackendType.INSTANCING -> new TextComponent("Using Instancing Engine").m_130940_(ChatFormatting.GREEN);
            case BackendType.BATCHING -> new TextComponent("Using Batching Engine").m_130940_(ChatFormatting.GREEN);
        };
    }

    public static class ConfigCommandBuilder {
        protected LiteralArgumentBuilder<CommandSourceStack> command;

        public ConfigCommandBuilder(String baseLiteral) {
            this.command = Commands.m_82127_((String)baseLiteral);
        }

        public <T extends ForgeConfigSpec.ConfigValue<?>> void addValue(T value, String subcommand, BiConsumer<LiteralArgumentBuilder<CommandSourceStack>, T> consumer) {
            LiteralArgumentBuilder builder = Commands.m_82127_((String)subcommand);
            consumer.accept((LiteralArgumentBuilder<CommandSourceStack>)builder, (LiteralArgumentBuilder<CommandSourceStack>)value);
            this.command.then((ArgumentBuilder)builder);
        }

        public void build(CommandDispatcher<CommandSourceStack> dispatcher) {
            dispatcher.register(this.command);
        }
    }
}

